<?php
require_once('../../../../wp-load.php');
require_once('../../../../wp-config.php');
require_once('../../../../wp-includes/load.php');

$existing_config_fn = basename(__FILE__) . '/config.ini';
if ( file_exists($existing_config_fn) )
    $export_config_params = parse_ini_file( basename(__FILE__) . '/config.ini', true);

$export_config = new stdClass();
$export_config->export_stream->export_variations = $export_config_params['export_stream']['export_variations'] ?? true;
$export_config->product_attrs->color  = $export_config_params['product_attrs']['color'] ?? 'pa_color';
$export_config->product_attrs->size   = $export_config_params['product_attrs']['size'] ?? 'pa_size';
$export_config->product_attrs->brand  = $export_config_params['product_attrs']['brand'] ?? 'pa_brand';
  
$remote_addr = ( isset($_SERVER['HTTP_CF_CONNECTING_IP']) && filter_var($_SERVER['HTTP_CF_CONNECTING_IP'], FILTER_VALIDATE_IP) ? $_SERVER['HTTP_CF_CONNECTING_IP'] : ( isset($_SERVER['HTTP_X_FORWARDED_FOR']) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : @$_SERVER['REMOTE_ADDR'] ) );

if ( empty($remote_addr) ) {
    header ( 'HTTP/1.1 400' );
    exit ('Restricted access');
}

$reverselookup = wp_safe_remote_get('https://www.mysitemapgenerator.com/api/reverselookup/'.$remote_addr);

if ( !isset($reverselookup['response']['code']) ||  $reverselookup['response']['code'] !== 202 ) {
    header ( 'HTTP/1.1 403' );
    exit ('Restricted access');
}
    
$loading_offset = !empty($_REQUEST['offset']) ? (int)$_REQUEST['offset'] : 0;
    
if ( isset($_REQUEST['limit']) )
    $loading_limit = (int)$_REQUEST['limit'];

ob_clean();

header ( 'Content-Type: text/csv; charset=utf-8' );
header ( 'Content-Disposition: attachment;filename=productdata.csv' );

$fp = fopen( 'php://output', 'w' );

$currency = get_woocommerce_currency();
$i = $c = 0;

if ( $loading_offset )
    $i = round($loading_offset / 50);
    
$i++;

while ( is_array( $products = wc_get_products( array( 'status' => 'publish', 'limit' => 50, 'page' => $i ) ) ) && sizeof( $products ) ) {
    $i++;
    
    if ( isset($loading_limit) && $loading_limit && $loading_limit<=$c )
        break;
 
    foreach ( $products as $product ) {
        if ( isset($loading_limit) && $loading_limit && $loading_limit<=$c )
            break;
        
        $is_variable = $product->is_type( 'variable' ) ? true : false;
        
        $product_base['url'] = get_permalink( $product->get_id() );
        $product_base['name'] = $product->get_title();
        $product_base['category'] = get_the_terms( $product->get_id(), 'product_cat' )[0]->name;
        
        if ( $export_config->export_stream->export_variations && $is_variable ) {
            $variations = $product->get_available_variations();

            foreach ( $variations as $product_variation ) {
                
                $product_variation['attributes'] = array_filter($product_variation['attributes'], 'strlen');
                
                if ( !empty($product_variation['attributes']) && !empty($product_variation['variation_is_visible']) ) {                    
                    $variation_url_params = http_build_query( $product_variation['attributes'] );
                    $variation_full_url = $product_base['url'] . ( preg_match('/\?/', $product_base['url']) ? '&' : '?') . $variation_url_params;
                    $variation_name = trim( $product_base['name'] . ' ' . implode(' ', $product_variation['attributes']) );
                
                    $line = array(
                        'url' => $variation_full_url,
                        'sku' => $product_variation['sku'] ?? $product->get_sku() ?? '',
                        'title' => $variation_name,
                        'gtin' => $product->get_attribute('ean'),
                        'brand' => $product->get_attribute( $export_config->product_attrs->brand ),
                        'description' => $product->get_short_description(),
                        'category' => $product_base['category'],
                        'image_link' => $product_variation['image']['src'],
                        'currency' => $currency,
                        'regular_price' => $product_variation['display_regular_price'],
                        'sale_price' => $product_variation['display_price'],
                        'color' => $product_variation['attributes']['attribute_' . $export_config->product_attrs->color] ?? $product_variation['attributes']['attribute_color'] ?? '',
                        'size' => $product_variation['attributes']['attribute_' . $export_config->product_attrs->size] ?? $product_variation['attributes']['attribute_size'] ?? '',
                        'availability' => $product_variation['is_in_stock'],
                    );
                    
                    if ( !isset($setheader) ) {
                        fputcsv($fp, array_keys($line), ';', '"');
                        $setheader = 1;
                    }
            
                    fputcsv($fp, $line, ';', '"'); ob_flush();
                    unset($line, $product_variation);
                }
            }
        }
        else {
            $line = array(
                'url' => $product_base['url'],
                'sku' => $product->get_sku(),
                'title' => $product_base['name'],
                'gtin' => $product->get_attribute('ean'),
                'brand' => $product->get_attribute( $export_config->product_attrs->brand ),
                'description' => $product->get_short_description(),
                'category' => $product_base['category'],
                'image_link' => wp_get_attachment_url( $product->get_image_id() ),
                'currency' => $currency,
                'regular_price' => ( $is_variable  ? $product->get_variation_regular_price( 'min' ) : $product->get_regular_price() ),
                'sale_price' => ( $is_variable  ? $product->get_variation_sale_price( 'min' ) : $product->get_sale_price() ),
                'color' => $product->get_attribute( $export_config->product_attrs->color ),
                'size' => $product->get_attribute( $export_config->product_attrs->size ),
                'availability' => $product->get_stock_status(),
            );
        }
        
        if ( !isset($setheader) ) {
            fputcsv($fp, array_keys($line), ';', '"');
            $setheader = 1;
        }

        fputcsv($fp, $line, ';', '"'); ob_flush();
        unset($line, $product);
        
        $c++;
    }
    
    unset($products);
    wp_cache_flush();
}

fclose($fp);
ob_flush();
?>