<?php
require_once('../../../../wp-load.php');
require_once('../../../../wp-config.php');
require_once('../../../../wp-includes/load.php');
  
$remote_addr = ( isset($_SERVER['HTTP_CF_CONNECTING_IP']) && filter_var($_SERVER['HTTP_CF_CONNECTING_IP'], FILTER_VALIDATE_IP) ? $_SERVER['HTTP_CF_CONNECTING_IP'] : ( isset($_SERVER['HTTP_X_FORWARDED_FOR']) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : @$_SERVER['REMOTE_ADDR'] ) );

if ( empty($remote_addr) ) {
    header ( 'HTTP/1.1 400' );
    exit ('Restricted access');
}

$reverselookup = wp_safe_remote_get('https://www.mysitemapgenerator.com/api/reverselookup/'.$remote_addr);

if ( !isset($reverselookup['response']['code']) ||  $reverselookup['response']['code']!==202 ) {
    header ( 'HTTP/1.1 403' );
    exit ('Restricted access');
}

$args = array(
    'limit'    => 50,
    'return'   => 'ids',
    'paginate' => true,
);

$wc_products = wc_get_products( $args );
$result['total_pages'] = $wc_products->max_num_pages;
$result['offset_limit'] = $wc_products->max_num_pages * $args['limit'];
$result['plugin_data'] = get_file_data('../MySitemapGeneratorProductSync.php', array('Version' => 'Version'), false);

header('Content-type: application/json; charset=utf-8');
echo json_encode($result);
exit();
?>